DROP procedure IF EXISTS `sp_listarDocumentosVenta`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_listarDocumentosVenta`(
	IN `p_idDocumentoVenta` INT, 
    IN `p_fechaInicio` DATE, IN `p_fechaFin` DATE, IN `p_estado` VARCHAR(2), IN `p_tipoOperacion` INT)
BEGIN    
	IF p_tipoOperacion = 1 
		THEN         
			SELECT
					DV.id,
					DV.correlativo,
					CASE WHEN C.idTipoCliente = 2
						THEN
							C.razonSocial
						ELSE
							concat(C.nombres, ' ', C.apellidoPaterno, ' ', C.apellidoMaterno) 
					END AS cliente_descripcion,
					M.descripcion AS tipo_documento_descripcion,
					DV.idMoneda, 
					M2.descripcion AS moneda_descripcion,
					DATE(DV.fecha_registro) AS fecha_registro,
					DATE(DV.fecha_emision) AS fecha_emision,
					DV.monto_subtotal,
					DV.monto_igv_total,
                    DV.monto_descuento_total,
					DV.monto_total,
					DV.monto_interes,
					DV.monto_total_interes,
					DV.estado,
					M3.descripcion AS estado_descripcion
			FROM 	DOCUMENTO_VENTA DV
					INNER JOIN CLIENTE C
						ON C.idCliente = DV.idCliente
						AND C.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.valor = DV.idTipoDocumento 
						AND M.dep_id = 15
						AND M.activo = 1
					INNER JOIN MULTITABLA M2
						ON M2.valor = DV.idMoneda 
						AND M2.dep_id = 20 
						AND M2.activo = 1
					INNER JOIN MULTITABLA M3
						ON M3.abrev = DV.estado 
						AND M3.dep_id = 25
						AND M3.activo = 1
			WHERE	(p_estado = '0' OR p_estado = DV.estado)
					AND (p_fechaInicio IS NULL OR p_fechaInicio <= DATE(DV.fecha_registro))
					AND (p_fechaFin IS NULL OR p_fechaFin >= DATE(DV.fecha_registro))
                    AND DV.activo = 1
			ORDER BY DV.correlativo DESC;
    END	IF; 
    
    IF p_tipoOperacion = 2 
		THEN  
			SELECT
					id,
					idCliente,
					idTipoDocumento,
					idMoneda,
					idFormaPago,
					idMedioPago,
					idCanal,
					correlativo,
					DATE(fecha_emision) AS fecha_emision,
					serie,
					numero,
                    tasa_cambio,
                    igv,
					monto_subtotal,
					monto_igv_total,
					monto_total,
					monto_interes,
					monto_total_interes,
					DATE(fecha_registro) AS fecha_registro,
					estado
			FROM 	DOCUMENTO_VENTA
			WHERE 	id = p_idDocumentoVenta;
    END	IF; 
    
    IF p_tipoOperacion = 3 
		THEN  
			SELECT
					DDV.id,
					DDV.cantidad,
					DDV.descuento,
					DDV.producto_id AS idProducto,
					P.nombre AS nombreProducto,
					DDV.igv_unitario AS igv,
					DDV.precio_unitario AS precioUnitario,
					P.stockActual AS stock,
					M.descripcion AS unidadMedida,
					DDV.valor_unitario AS valorUnitario,
                    DDV.valor_total AS valorTotal,
					DDV.precio_total AS precioTotal
			FROM	DETALLE_DOCUMENTO_VENTA DDV
					INNER JOIN PRODUCTO P
						ON P.idProducto = DDV.producto_id AND P.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.dep_id = 3 AND P.unidad_medida = M.abrev
			WHERE 	DDV.documento_venta_id = p_idDocumentoVenta
					AND DDV.activo = 1;
    END	IF; 
    
    IF p_tipoOperacion = 4
		THEN  
			SELECT
					CPV.id,
					CPV.capital_cuota AS capitalCuota,
                    CPV.cuota,
                    DATE(CPV.fecha_pago_cuota) AS fechaPago,
                    CPV.importe_cuota AS importeCuota,
                    CPV.interes_cuota AS interesCuota,
                    FP.interes
			FROM	CRONOGRAMA_PAGO_VENTA CPV
					INNER JOIN DOCUMENTO_VENTA DV
						ON DV.id = CPV.documento_venta_id AND DV.activo = 1
					INNER JOIN FORMA_PAGO FP
						ON FP.id = DV.idFormaPago AND FP.activo = 1
            WHERE	CPV.documento_venta_id = p_idDocumentoVenta
					AND CPV.activo = 1;
    END	IF;
    
    IF p_tipoOperacion = 5
		THEN  
			SELECT
					DV.id,
					DV.correlativo,
					CASE WHEN C.idTipoCliente = 2
						THEN
							C.razonSocial
						ELSE
							concat(C.nombres, ' ', C.apellidoPaterno, ' ', C.apellidoMaterno) 
					END AS cliente_descripcion,
                    C.documento AS documento_cliente,
                    C.direccion,
                    C.telefono1,
					M.descripcion AS tipo_documento_descripcion,
					DV.idMoneda,
					M2.descripcion AS moneda_descripcion,
					DATE_FORMAT(DV.fecha_registro, '%d/%m/%Y') AS fecha_registro,
                    DATE_FORMAT(DV.fecha_emision, '%d/%m/%Y') AS fecha_emision,
                    DV.tasa_cambio,
                    DV.igv,
					DV.monto_subtotal,
					DV.monto_igv_total,
                    DV.monto_descuento_total,
					DV.monto_total,
					DV.monto_interes,
					DV.monto_total_interes,
					DV.estado,
                    FP.nombre AS forma_pago_descripcion,
                    DV.serie,
                    DV.numero
			FROM 	DOCUMENTO_VENTA DV
					INNER JOIN CLIENTE C
						ON C.idCliente = DV.idCliente
						AND C.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.valor = DV.idTipoDocumento 
						AND M.dep_id = 15
						AND M.activo = 1
					INNER JOIN MULTITABLA M2
						ON M2.valor = DV.idMoneda 
						AND M2.dep_id = 20 
						AND M2.activo = 1
					INNER JOIN FORMA_PAGO FP
						ON FP.id = DV.idFormaPago
                        AND FP.activo = 1
			WHERE	DV.id = p_idDocumentoVenta;
    END	IF;
    
    IF p_tipoOperacion = 6
		THEN  
			SELECT
					DDV.id,
                    P.codigo AS codigoProducto,
					DDV.cantidad,
					DDV.descuento,
					DDV.producto_id AS idProducto,
					P.nombre AS nombreProducto,
					DDV.igv_unitario AS igv,
					DDV.precio_unitario AS precioUnitario,
					P.stockActual AS stock,
					M.descripcion AS unidadMedida,
					DDV.valor_unitario AS valorUnitario,
                    DDV.valor_total AS valorTotal,
					DDV.precio_total AS precioTotal
			FROM	DETALLE_DOCUMENTO_VENTA DDV
					INNER JOIN PRODUCTO P
						ON P.idProducto = DDV.producto_id AND P.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.dep_id = 3 AND P.unidad_medida = M.abrev
			WHERE 	DDV.documento_venta_id = p_idDocumentoVenta
					AND DDV.activo = 1;
    END	IF; 
   
END$$

DELIMITER ;